
; This is WinCnst3~Inc~

; This file contains the constants and structures
; used by the window and font related routines.


; Constants for draw/erase/invert/pattern verbs

drawVerb      EQU 0
eraseVerb     EQU 1
invertVerb    EQU 2
mergeVerb     EQU 3
ptnVerbsBit   EQU 4

; Constants for orientations that a window can have

north         EQU 0
west          EQU 1
south         EQU 2
east          EQU 3

; Constants for types of offscreen window formats

screenFormat  EQU 0
genericFormat EQU 1

; Constants relating to cursors

cursorWidth  EQU 16
cursorHeight EQU 16

; Constants for defining frame shapes

rectFrame    EQU 0

; Constants for defining frame embellishments

; Bits of frame value are defined as:
;   0-1: Width of inner frame
;   2-3: Width of space between frames
;   4-5: Width of outer frame
;   6-7: Width of shadow
;   8-9: (0=NE Shadow; 1=NW Shadow; 2=SE Shadow; 3=SW Shadow)
;   10-15: Reserved for future use.

noFrame      EQU 0
simpleFrame  EQU 0001H
se3DShadow2  EQU 0281H	; southwest 3-D shadow that is 2 pixels wide
boldFrame    EQU 0002H	; even frame around rect that is 2 pixs wide
pictureFrame EQU 0029H	; single frame, 2 spaces, double frame


; structures

PointType STRUC
	pointX        DW ?
	pointY        DW ?
PointType ENDS

RectangleType STRUC
	rectTopLeftX  DW ?
	rectTopLeftY  DW ?
	rectExtentX   DW ?
	rectExtentY   DW ?
RectangleType ENDS

FontInfoType STRUC
	fiVers        DW ?
	fiFileSize    DW ?
	fiFileSizeHi  DB ?
	fiOrientation DB ?
	fiCopyright   DB 60 DUP (?)
	fiFntClass    DW ?
	fiPointSize   DW ?
	fiVertRes     DW ?
	fiHorizRes    DW ?
	fiBaseLine    DW ?
	fiIntLead     DW ?
	fiExtLead     DW ?
	fiItalic      DB ?
	fiUnderline   DB ?
	fiStrikeOut   DB ?
	fiWeight      DW ?
	fiCharSet     DB ?
	fiPixWidth    DW ?
	fiPixHeight   DW ?
	fiPitchFmly   DB ?
	fiAvgWidth    DW ?
	fiMaxWidth    DW ?
	fiFirstChar   DB ?
	fiLastChar    DB ?
	fiDfltChar    DB ?
	fiBreakChar   DB ?
	fiWidBytes    DW ?
	fiDevName     DD ?
	fiFaceName    DD ?
	fiSomething   DD ?
	fiBitsData    DD ?
	fiFiller      DB ?
	fiChInfBase   DB ?
FontInfoType ENDS

; The first three fields of this structure are arranged such that they overlap
; the fields returned by GfxScreenInfo.  The fields wiWindowFlags and
; wiBoundsTopLeftX will be overwritten with yAspect and bitsPerPel.

; The windowFlags fields has the following bits defined:
;   Bit 0 is window format:  0=screen mode; 1=generic mode
;   Bit 1 is offscreen flag: 0=onscreen window; 1=offscreen window
;   Bit 2 is modal flag:     0=modeless window; 1=modal window
;   Bit 3 is title flag:     0=no title area; 1=has title area
;   Bit 4 is enabled flag:   0=window disabled; 1=window enabled
;   Bit 5 is form win flag:  0=non-form window; 1=form's window

wiWinFormatFlag EQU      1b
wiOffscreenFlag EQU     10b
wiModalFlag     EQU    100b
wiTitleFlag     EQU   1000b
wiEnabledFlag   EQU  10000b
wiFormWinFlag   EQU 100000b

; Note: If more fields are added then changes will probably have to be made
; in the initialization routine (MiniInit) and WinCreateWindow &
; WinCreateOffscreenWindow (WinWndws).

WindowInfoType STRUC
	wiDisplayWidth   DW ?
	wiDisplayHeight  DW ?
	wiDisplayAddr    DW ?
	wiWindowFlags    DW ?
	wiBoundsTopLeftX DW ?
	wiBoundsTopLeftY DW ?
	wiBoundsExtentX  DW ?
	wiBoundsExtentY  DW ?
	wiClipLeft       DW ?
	wiClipTop        DW ?
	wiClipRight      DW ?
	wiClipBottom     DW ?
	wiNextWindow     DW ?
	wiFrameType      DW ?
	wiUserData       DD ?
	wiTitlePtr       DD ?
	wiTitleLen       DW ?
WindowInfoType ENDS
